package com.example.demo.controller;

import com.example.demo.domain.Article;
import com.example.demo.domain.dto.ArticleRequest;
import com.example.demo.domain.dto.ArticleResponse;
import com.example.demo.repository.IArticleRepository;
import com.example.demo.service.contract.IArticleService;
import lombok.AllArgsConstructor;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeToken;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("article")
@AllArgsConstructor
public class ArticleController {
    private ModelMapper modelMapper = new ModelMapper();
    private IArticleRepository articleRepository;
    private IArticleService articleService;

    @GetMapping
    public ResponseEntity getAllArticles(){
        List<Article> articleList = articleRepository.findAll();
        if(articleList.stream().count() > 0){
            List<ArticleResponse> response = modelMapper.map(articleList, new TypeToken<List<ArticleResponse>>() {}.getType());
            return new ResponseEntity(articleList, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @GetMapping("/{id}")
    public ResponseEntity getAllArticles(@PathVariable("id") Long id){
        Optional<Article> article = articleRepository.findById(id);
        if(article != null){
            ArticleResponse response = modelMapper.map(article, ArticleResponse.class);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping
    public ResponseEntity addArticle(@RequestBody ArticleRequest articleRequest) {
        try {
            Article article = articleService.addArticle(articleRequest);
            return new ResponseEntity(article, HttpStatus.OK);
        } catch (Exception e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping("/{id}")
    public ResponseEntity deleteArticle(@PathVariable Long id){
        try{
            articleRepository.deleteById(id);
            return new ResponseEntity("Article with id: "+ id + "is succesfully deleted!", HttpStatus.OK);
        } catch (Exception e){
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}
