package com.example.demo.controller;

import com.example.demo.domain.Basket;
import com.example.demo.domain.dto.BasketAddItemRequest;
import com.example.demo.service.contract.IShopService;
import lombok.AllArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("shopping")
@AllArgsConstructor
public class ShoppingController {
    private IShopService shopService;

    @PutMapping("/basket/item")
    @Secured(value = "ROLE_USER")
    public ResponseEntity addArticleToBasket(BasketAddItemRequest basketAddItemRequest){
        Basket selectedBasket = shopService.AddArticleToBsket(basketAddItemRequest);
        if(selectedBasket != null){
            return new ResponseEntity(selectedBasket, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping("/basket/{basketId}/{itemId}")
    @Secured(value = "ROLE_USER")
    public ResponseEntity removeArticleFromBasket(@PathVariable Long basketId, @PathVariable Long itemId){
        Basket selectedBasket = shopService.RemoveArticleFromBasket(basketId, itemId);
        if(selectedBasket != null){
            return new ResponseEntity(selectedBasket, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @GetMapping("/basket/{id}")
    @Secured(value = "ROLE_USER")
    public ResponseEntity getBasket(@PathVariable Long id){
        Basket selectedBasket = shopService.GetBasket(id);
        if(selectedBasket != null){
            return new ResponseEntity(selectedBasket, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PutMapping("/basket/paying/{id}")
    @Secured(value = "ROLE_USER")
    public ResponseEntity payingBasket(@PathVariable Long id){
        if(shopService.PayingBasket(id)){
            return new ResponseEntity("Basket with id: " + id + " is payed!", HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @GetMapping("/exit")
    @ResponseStatus(HttpStatus.OK)
    //@Secured(value = "ROLE_USER")
    public void logout(HttpServletRequest request) {
        try {
            request.logout();
        } catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }
}