package com.example.demo.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

@Entity
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Basket {
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;

    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private List<CardItem> items = new ArrayList<>();

    private boolean payed;
    public void addItem(CardItem item) {
        if(items == null) items = new ArrayList<>();
        items.add(item);
    }

    public void removeItem(CardItem item) {
        items.remove(item);
    }

}
