package com.example.demo.service;

import com.example.demo.domain.Article;
import com.example.demo.domain.dto.ArticleRequest;
import com.example.demo.repository.IArticleRepository;
import com.example.demo.service.contract.IArticleService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor
public class ArticleService implements IArticleService {
    private final IArticleRepository articleRepository;

    @Override
    public Article addArticle(ArticleRequest request) {
        Article article = Article.builder().name(request.getName()).price(request.getPrice()).ean(request.getEan()).build();
        articleRepository.save(article);
        return article;
    }
}
