package com.example.demo.service;

import com.example.demo.domain.Article;
import com.example.demo.domain.Basket;
import com.example.demo.domain.CardItem;
import com.example.demo.domain.dto.BasketAddItemRequest;
import com.example.demo.repository.IArticleRepository;
import com.example.demo.repository.IBasketRepository;
import com.example.demo.repository.ICardRepository;
import com.example.demo.service.contract.IShopService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Optional;

@Service
@AllArgsConstructor
@Slf4j
public class ShopService implements IShopService {
    private IArticleRepository articleRepository;
    private IBasketRepository basketRepository;
    private ICardRepository cardItemRepository;

    @Override
    @Transactional
    public Basket AddArticleToBsket(BasketAddItemRequest basketAddItemRequest) {
        try{
            // Check and set if new basket is needed.
            Optional<Basket> basket = basketRepository.findById(basketAddItemRequest.getBasketId());
            if(basket.isEmpty()) basket = Optional.ofNullable(new Basket());
            Basket selectedBasket = basket.get();

            // Check and get Article
            Optional<Article> article = articleRepository.findById(basketAddItemRequest.getArticleId());
            if(article.isPresent()){
                CardItem item = CardItem.builder().article(article.get()).amount(basketAddItemRequest.getAmount()).build();

                selectedBasket.addItem(item);
                basketRepository.save(selectedBasket);
                return selectedBasket;
            }
        }catch (Exception ex){
            log.info(ex.getMessage());
        }
        return null;
    }

    @Override
    @Transactional
    public Basket RemoveArticleFromBasket(Long basketId, Long itemId) {
        try{
            Optional<Basket> basket = basketRepository.findById(basketId);
            Optional<CardItem> item = cardItemRepository.findById(itemId);
            if(basket.isPresent() && item.isPresent()) {
                Basket selectedBasket = basket.get();
                CardItem selectedItem = item.get();

                selectedBasket.removeItem(selectedItem);
                basketRepository.save(selectedBasket);
                return selectedBasket;
            }
        } catch (Exception ex){
            log.info(ex.getMessage());
        }
        return null;
    }

    @Override
    public Basket GetBasket(Long id) {
        Optional<Basket> selectedBasket = basketRepository.findById(id);
        if(selectedBasket.isPresent()){
            return selectedBasket.get();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean PayingBasket(Long id) {
        try {
            Optional<Basket> basket = basketRepository.findById(id);
            if (basket.isPresent()) {
                Basket selectedBasket = basket.get();
                if(selectedBasket.isPayed()){
                    return false;
                }
                selectedBasket.setPayed(true);
                basketRepository.save(selectedBasket);
                return true;
            }
        } catch (Exception ex){
            log.info(ex.getMessage());
        }
        return false;
    }
}
