package com.example.demo.service.aspect;

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.*;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Slf4j
public class ShopAspect {
    @Before("execution(* com.example.demo.service.*.*(..))")
    public void before(JoinPoint joinPoint) {
        //Advice
        System.out.println("Before aspect is called!");
        log.info("Before: " + joinPoint.getSignature().getName());
    }

    @After("execution(* com.example.demo.service.*.*(..))")
    public void after(JoinPoint joinPoint) {
        //Advice
        System.out.println("After aspect is called!");
        log.info("After: " + joinPoint.getSignature().getName());
    }
    @AfterReturning("execution(* com.example.demo.service.*.*(..))")
    public void afterReturning(JoinPoint joinPoint) {
        //Advice
        System.out.println("AfterReturning Aspect is called!");
        log.info("AfterReturning: " + joinPoint.getSignature().getName());
    }
//    @AfterThrowing("execution(* com.example.demo.services.*.*(..))")
//    public void afterThrowing(JoinPoint joinPoint) {
//        //Advice
//        log.info("Aspect after throwing called!");
//        System.out.println("Aspect after throwing called!");
//    }
//
//    @Around("execution(* com.example.demo.services.*.*(..))")
//    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
//        // Before
//
//        System.out.println("Around...");
//
//        // hoe lang was vorige call
//        // > 5min geleden
//        // then joinPoint.proceed()
//        // else too_busy
//
//        // return result
//        Object result = joinPoint.proceed();
//
//        // After
//
//        System.out.println(result);
//
//        return result;
//        // after returning
//        // after throwing
//    }
}
