package com.example.demo.repository;

import com.example.demo.domain.Article;
import com.example.demo.domain.dto.ArticleRequest;
import com.example.demo.repository.IArticleRepository;
import com.example.demo.service.contract.IShopService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

import java.util.Optional;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest
@Testcontainers
@AutoConfigureMockMvc
public class ArticleRepositoryTests {
    @Autowired
    private MockMvc mockMvc;
    @Autowired
    private ObjectMapper mapper;

    @Autowired
    private IArticleRepository articleRepository;

    @Container
    static MySQLContainer mySQLContainer =
            new MySQLContainer("mysql:5:7:37");

    @BeforeEach
    public void setup(){
        articleRepository.deleteAll();
    }

    @DynamicPropertySource
    static void registerMySQLProperties(DynamicPropertyRegistry registry) {
        registry.add("spring.datasource.url", mySQLContainer::getJdbcUrl);
        registry.add("spring.datasource.username", mySQLContainer::getUsername);
        registry.add("spring.datasource.password", mySQLContainer::getPassword);
    }

    @Test
    public void save() throws Exception {
        Article article = Article.builder().name("3x3mm").ean("ASDFQWEG").price(0.8).build();
        articleRepository.save(article);
        Assertions.assertEquals(1, articleRepository.findAll().size());
    }

    @Test
    public void findById() throws Exception {
        Article article = Article.builder().name("3x3mm").ean("ASDFQWEG").price(0.8).build();
        article = articleRepository.save(article);

        Optional<Article> result = articleRepository.findById(article.getId());

        Assertions.assertEquals(true, result.isPresent());
    }

    @Test
    public void remove() throws Exception {
        Article article = Article.builder().name("3x3mm").ean("ASDFQWEG").price(0.8).build();
        article = articleRepository.save(article);

        articleRepository.delete(article);

        Optional<Article> result = articleRepository.findById(article.getId());

        Assertions.assertEquals(false, result.isPresent());
    }
}
